<?php

function changeCameraSettings()
{
   $sock = Login();
   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";
   if (stripos($content_type, "application/json") === false) {
      throw new Exception("Content-Type must be application/json");
   }
   $object = json_decode(file_get_contents("php://input"), true);
   $camcurip = $object["oldIp"];
   $camport = $object["port"];
   $camnewip = $object["newIp"];
   $prefixLength = $object["mask"];
   ParamSetString($sock, "server.onvifcamlogin", ConvertUTF2Native($object["login"]));
   ParamSetString($sock, "server.onvifcampassword", ConvertUTF2Native($object["password"]));
   sleep(3);
   $status = OnvifChangeCameraIP($sock, $camcurip, $camport, $camnewip, $prefixLength);
   socket_close($sock);
   return $status;
}
function fixConflicts()
{
   $sock = Login();
   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";
   if (stripos($content_type, "application/json") === false) {
      throw new Exception("Content-Type must be application/json");
   }
   $object = json_decode(file_get_contents("php://input"), true);
   $pingip1 = $object["startIp"];
   $pingip2 = $object["endIp"];
   $pingprefixLength = $object["mask"];
   ParamSetString($sock, "server.onvifcamlogin", ConvertUTF2Native($object["login"]));
   ParamSetString($sock, "server.onvifcampassword", ConvertUTF2Native($object["password"]));
   sleep(3);
   $status = OnvifConflictResolve($sock, $pingip1, $pingip2, $pingprefixLength);
   socket_close($sock);
   return $status;
}
